/*!
 * angularjs-color-picker v3.4.8
 * https://github.com/ruhley/angular-color-picker/
 *
 * Copyright 2017 ruhley
 *
 * 2017-10-06 09:51:57
 *
 */
!function(o,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t(require("tinycolor2")):"function"==typeof define&&define.amd?define(["tinycolor2"],t):o.AngularjsColorPicker=t(o.tinycolor)}(this,function(o){"use strict";function t(o){o.put("template/color-picker/directive.html",'<div class="color-picker-wrapper" ng-class="{\'color-picker-disabled\': AngularColorPickerController.options.disabled,\'color-picker-swatch-only\': AngularColorPickerController.options.swatchOnly,\'color-picker-open\': AngularColorPickerController.is_open,\'color-picker-closed\': !AngularColorPickerController.is_open,\'color-picker-horizontal\': AngularColorPickerController.options.horizontal,}"><div class="color-picker-input-wrapper" ng-class="{\'input-group\': AngularColorPickerController.options.swatchBootstrap && AngularColorPickerController.options.swatch}"><span ng-if="AngularColorPickerController.options.swatchPos === \'left\'" class="color-picker-swatch" ng-click="AngularColorPickerController.onSwatchClick($event)" ng-show="AngularColorPickerController.options.swatch" ng-class="{\'color-picker-swatch-left\': AngularColorPickerController.options.swatchPos !== \'right\', \'color-picker-swatch-right\': AngularColorPickerController.options.swatchPos === \'right\', \'input-group-addon\': AngularColorPickerController.options.swatchBootstrap}"></span><input ng-attr-id="{{AngularColorPickerController.options.id}}" ng-attr-name="{{AngularColorPickerController.options.name}}" class="color-picker-input {{AngularColorPickerController.options.inputClass}}" type="text" ng-model="AngularColorPickerController.internalNgModel" ng-model-options="AngularColorPickerController.ngModelOptions" ng-readonly="AngularColorPickerController.options.swatchOnly" ng-disabled="AngularColorPickerController.options.disabled" ng-change="AngularColorPickerController.onChange($event)" size="7" ng-class="{\'color-picker-input-swatch\': AngularColorPickerController.options.swatch && !AngularColorPickerController.options.swatchOnly && AngularColorPickerController.options.swatchPos === \'left\'}" placeholder="{{AngularColorPickerController.options.placeholder}}" ng-required="AngularColorPickerController.options.required"><span ng-if="AngularColorPickerController.options.swatchPos === \'right\'" class="color-picker-swatch" ng-click="AngularColorPickerController.onSwatchClick($event)" ng-show="AngularColorPickerController.options.swatch" ng-class="{\'color-picker-swatch-left\': AngularColorPickerController.options.swatchPos !== \'right\', \'color-picker-swatch-right\': AngularColorPickerController.options.swatchPos === \'right\', \'input-group-addon\': AngularColorPickerController.options.swatchBootstrap}"></span></div><div class="color-picker-panel" ng-class="{\'color-picker-panel-top color-picker-panel-right\': AngularColorPickerController.options.pos === \'top right\',\'color-picker-panel-top color-picker-panel-left\': AngularColorPickerController.options.pos === \'top left\',\'color-picker-panel-bottom color-picker-panel-right\': AngularColorPickerController.options.pos === \'bottom right\',\'color-picker-panel-bottom color-picker-panel-left\': AngularColorPickerController.options.pos === \'bottom left\',\'color-picker-panel-round\': AngularColorPickerController.options.round,\'color-picker-show-hue\': AngularColorPickerController.options.hue,\'color-picker-show-saturation\': AngularColorPickerController.options.saturation,\'color-picker-show-lightness\': AngularColorPickerController.options.lightness,\'color-picker-show-alpha\': AngularColorPickerController.options.alpha && AngularColorPickerController.options.format !== \'hex\',\'color-picker-show-inline\': AngularColorPickerController.options.inline,}"><div class="color-picker-grid-wrapper"><div class="color-picker-row"><div class="color-picker-grid"><div class="color-picker-overlay"></div><div class="color-picker-grid-inner"></div><div class="color-picker-picker"><div></div></div></div><div class="color-picker-hue" ng-show="AngularColorPickerController.options.hue"><div class="color-picker-overlay"></div><div class="color-picker-slider"></div></div><div class="color-picker-saturation" ng-show="AngularColorPickerController.options.saturation"><div class="color-picker-overlay"></div><div class="color-picker-slider"></div></div><div class="color-picker-lightness" ng-show="AngularColorPickerController.options.lightness"><div class="color-picker-overlay"></div><div class="color-picker-slider"></div></div><div class="color-picker-opacity" ng-show="AngularColorPickerController.options.alpha && AngularColorPickerController.options.format !== \'hex\'"><div class="color-picker-overlay"></div><div class="color-picker-slider"></div></div></div></div><div class="color-picker-actions"><button type="button"class="color-picker-action color-picker-action-clear"tabindex="-1"ng-class="AngularColorPickerController.options.clear.class"ng-show="AngularColorPickerController.options.clear.show"ng-click="AngularColorPickerController.api.clear($event)">{{AngularColorPickerController.options.clear.label}}</button><button type="button"class="color-picker-action color-picker-action-reset"tabindex="-1"ng-class="AngularColorPickerController.options.reset.class"ng-show="AngularColorPickerController.options.reset.show"ng-click="AngularColorPickerController.api.reset($event)">{{AngularColorPickerController.options.reset.label}}</button><button type="button"class="color-picker-action color-picker-action-close"tabindex="-1"ng-class="AngularColorPickerController.options.close.class"ng-show="AngularColorPickerController.options.close.show"ng-click="AngularColorPickerController.api.close($event)">{{AngularColorPickerController.options.close.label}}</button></div></div></div>')}o=o&&o.hasOwnProperty("default")?o.default:o;var e="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},i=(function(){function o(o){this.value=o}function t(t){function e(n,r){try{var s=t[n](r),l=s.value;l instanceof o?Promise.resolve(l.value).then(function(o){e("next",o)},function(o){e("throw",o)}):i(s.done?"return":"normal",s.value)}catch(o){i("throw",o)}}function i(o,t){switch(o){case"return":n.resolve({value:t,done:!0});break;case"throw":n.reject(t);break;default:n.resolve({value:t,done:!1})}(n=n.next)?e(n.key,n.arg):r=null}var n,r;this._invoke=function(o,t){return new Promise(function(i,s){var l={key:o,arg:t,resolve:i,reject:s,next:null};r?r=r.next=l:(n=r=l,e(o,t))})},"function"!=typeof t.return&&(this.return=void 0)}"function"==typeof Symbol&&Symbol.asyncIterator&&(t.prototype[Symbol.asyncIterator]=function(){return this}),t.prototype.next=function(o){return this._invoke("next",o)},t.prototype.throw=function(o){return this._invoke("throw",o)},t.prototype.return=function(o){return this._invoke("return",o)}}(),function(o,t){if(!(o instanceof t))throw new TypeError("Cannot call a class as a function")}),n=function(){function o(o,t){for(var e=0;e<t.length;e++){var i=t[e];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(o,i.key,i)}}return function(t,e,i){return e&&o(t.prototype,e),i&&o(t,i),t}}(),r=function(){function t(o,e,n,r,s){i(this,t),this.$scope=o,this.$element=e,this.$document=n,this.$timeout=r,this.ColorPickerOptions=s,this.$scope.init=this.init.bind(this),this.ngModelOptions={},this.hue=0,this.saturation=void 0,this.lightness=void 0,this.opacity=void 0,this.basicEventTypes=["hue","saturation","lightness","opacity"],this.fullEventTypes=["color","hue","saturation","lightness","opacity"]}return n(t,[{key:"init",value:function(){this.$scope.control[0].$options&&this.$scope.control[0].$options.$$options&&(this.ngModelOptions=this.$scope.control[0].$options.$$options),this.chrome=Boolean(window.chrome);var o=window.navigator.userAgent.match(/Android\s([0-9\.]*)/i);this.android_version=o&&o.length>1?parseFloat(o[1]):NaN,this.updateModel=!0,this.initWatchers(),this.initConfig(),this.initMouseEvents()}},{key:"initConfig",value:function(){this.options||(this.options={}),this.mergeOptions(this.options,this.ColorPickerOptions),this.is_open=this.options.inline,this.options.inline&&(this.options.close.show=!1),this.pickerDimensions={width:150,height:150},this.sliderDimensions={width:this.options.horizontal?this.pickerDimensions.width:20,height:this.options.horizontal?20:this.pickerDimensions.height}}},{key:"mergeOptions",value:function(o,t){for(var i in t)t.hasOwnProperty(i)&&(o&&o.hasOwnProperty(i)?"object"===e(t[i])&&this.mergeOptions(o[i],t[i]):o[i]=t[i])}},{key:"initWatchers",value:function(){var o=this;this.$scope.$watch("AngularColorPickerController.internalNgModel",this.watchInternalNgModel.bind(this)),this.$scope.$watch("AngularColorPickerController.ngModel",this.watchNgModel.bind(this)),this.$scope.$watch("AngularColorPickerController.options.swatchPos",function(t){void 0!==t&&(o.initConfig(),o.$timeout(function(){o.updateSwatchBackground()}))}),this.$scope.$watchGroup(["AngularColorPickerController.options.format","AngularColorPickerController.options.alpha","AngularColorPickerController.options.case","AngularColorPickerController.options.round","AngularColorPickerController.options.restrictToFormat","AngularColorPickerController.options.preserveInputFormat","AngularColorPickerController.options.allowEmpty","AngularColorPickerController.options.horizontal","AngularColorPickerController.options.dynamicHue","AngularColorPickerController.options.dynamicSaturation","AngularColorPickerController.options.dynamicLightness","AngularColorPickerController.options.dynamicAlpha"],function(t){void 0!==t&&(o.initConfig(),o.update())}),this.$scope.$watchGroup(["AngularColorPickerController.options.disabled","AngularColorPickerController.options.swatchBootstrap","AngularColorPickerController.options.swatchOnly","AngularColorPickerController.options.swatch","AngularColorPickerController.options.pos","AngularColorPickerController.options.inline","AngularColorPickerController.options.placeholder"],function(t){void 0!==t&&o.initConfig()}),this.$scope.$watch("AngularColorPickerController.api",this.setupApi.bind(this)),this.$scope.$watch("AngularColorPickerController.swatchColor",this.updateSwatchBackground.bind(this)),this.$scope.$watch("AngularColorPickerController.hue",function(){o.valueUpdate("hue")}),this.$scope.$watch("AngularColorPickerController.saturation",function(){o.valueUpdate("saturation")}),this.$scope.$watch("AngularColorPickerController.lightness",function(){o.valueUpdate("lightness")}),this.$scope.$watch("AngularColorPickerController.opacity",function(){o.valueUpdate("opacity")})}},{key:"watchInternalNgModel",value:function(o,t){this.colorMouse||this.watchNgModelSet(o)}},{key:"watchNgModel",value:function(o,t){void 0===o||this.hasOwnProperty("initialNgModel")||(this.initialNgModel=o),this.checkDirty(o),this.internalNgModel=this.ngModelOptions.getterSetter?this.ngModel():this.ngModel,this.colorMouse||this.watchNgModelSet(o)}},{key:"watchNgModelSet",value:function(t){var e=this;if(void 0!==t&&null!==t){var i=o(t),n=this.isColorValid(i);n&&(this.setColorValue(i),this.updateModel=!1,this.$timeout(function(){e.updateModel=!0})),this.$scope.control[0].$setValidity("color",n)}else null!==t&&""!==t||(this.hue=0,this.saturation=void 0,this.lightness=void 0,this.opacity=void 0),this.swatchColor=""}},{key:"initMouseEvents",value:function(){var o=this,t={mouseDown:this.onMouseDown.bind(this),mouseUp:this.onMouseUp.bind(this),mouseMove:this.onMouseMove.bind(this),keyUp:this.onKeyUp.bind(this)};this.$document.on("mousedown",t.mouseDown),this.$document.on("mouseup",t.mouseUp),this.$document.on("mousemove",t.mouseMove),this.$document.on("touchstart",t.mouseDown),this.$document.on("touchend",t.mouseUp),this.$document.on("touchmove",t.mouseMove),this.$document.on("keyup",t.keyUp),this.find(".color-picker-grid").on("click",function(t){o.onClick("color",t)}),this.find(".color-picker-grid").on("touchend",function(t){o.onClick("color",t)}),this.find(".color-picker-hue").on("click",function(t){o.onClick("hue",t)}),this.find(".color-picker-hue").on("touchend",function(t){o.onClick("hue",t)}),this.find(".color-picker-saturation").on("click",function(t){o.onClick("saturation",t)}),this.find(".color-picker-saturation").on("touchend",function(t){o.onClick("saturation",t)}),this.find(".color-picker-lightness").on("click",function(t){o.onClick("lightness",t)}),this.find(".color-picker-lightness").on("touchend",function(t){o.onClick("lightness",t)}),this.find(".color-picker-opacity").on("click",function(t){o.onClick("opacity",t)}),this.find(".color-picker-opacity").on("touchend",function(t){o.onClick("opacity",t)}),this.find(".color-picker-input").on("focusin",this.onFocus.bind(this)),this.find(".color-picker-input").on("focusout",this.onBlur.bind(this)),this.$scope.$on("$destroy",function(){o.$document.off("mousedown",t.mouseDown),o.$document.off("mouseup",t.mouseUp),o.$document.off("mousemove",t.mouseMove),o.$document.off("touchstart",t.mouseDown),o.$document.off("touchend",t.mouseUp),o.$document.off("touchmove",t.mouseMove),o.$document.off("keyup",t.keyUp),o.eventApiDispatch("onDestroy")})}},{key:"onMouseDown",value:function(o){if(this.has_moused_moved=!1,this.options.disabled||0===this.find(o.target).length)return!0;for(var t=0;t<this.fullEventTypes.length;t++)this.onMouseDownType(this.fullEventTypes[t],o)}},{key:"onMouseDownType",value:function(o,t){"color"===o&&(t.target.classList.contains("color-picker-grid-inner")||t.target.classList.contains("color-picker-picker")||t.target.parentNode.classList.contains("color-picker-picker"))?this.mouseEventToggle(o,!1,t):(t.target.classList.contains("color-picker-"+o)||t.target.parentNode.classList.contains("color-picker-"+o))&&this.mouseEventToggle(o,!1,t)}},{key:"onMouseUp",value:function(o){if(this.anyMouseEvents()||0!==this.find(o.target).length)for(var t=0;t<this.fullEventTypes.length;t++)this.onMouseUpType(this.fullEventTypes[t],o);else this.setupApi(),this.options.hide.click&&this.api.close(o),this.$scope.$apply()}},{key:"onMouseUpType",value:function(o,t){this[o+"Mouse"]&&this.has_moused_moved&&(this.mouseEventToggle(o,!0,t),this.onChange(t))}},{key:"onMouseMove",value:function(o){for(var t=0;t<this.fullEventTypes.length;t++)this.onMouseMoveType(this.fullEventTypes[t],o)}},{key:"onMouseMoveType",value:function(o,t){this[o+"Mouse"]&&(this.has_moused_moved=!0,this.valueChange(o,t),this.$scope.$apply())}},{key:"onKeyUp",value:function(o){this.options.hide.escape&&27===o.keyCode&&this.api.close(o)}},{key:"onClick",value:function(o,t){this.options.disabled||this.has_moused_moved||(this.valueChange(o,t),this.mouseEventToggle(o,!0,t),this.onChange(t))}},{key:"onChange",value:function(o){this.internalNgModel!==this.onChangeValue&&(this.onChangeValue=this.internalNgModel,this.eventApiDispatch("onChange",[o]))}},{key:"onBlur",value:function(o){this.internalNgModel!==this.onChangeValue&&(this.updateModel=!0,this.update()),this.$scope.control[0].$setTouched(),this.eventApiDispatch("onBlur",[o]),this.options.hide.blur&&0===this.find(o.relatedTarget).length&&this.api.close(o)}},{key:"onSwatchClick",value:function(o){this.options.show.swatch&&!this.options.disabled&&this.api.open(o)}},{key:"onFocus",value:function(o){this.options.show.focus&&this.api.open(o)}},{key:"setupApi",value:function(){var o=this;this.api||(this.api={}),this.api.open=function(t){if(o.is_open)return!0;o.is_open=!0,o.hueMouse=!1,o.opacityMouse=!1,o.colorMouse=!1,o.$scope.$applyAsync();for(var e=0;e<o.basicEventTypes.length;e++)o.valueUpdate(o.basicEventTypes[e]);o.eventApiDispatch("onOpen",[t])},this.api.close=function(t){o.options.inline||!o.is_open&&null===o.$element[0].querySelector(".color-picker-panel").offsetParent||(o.is_open=!1,o.$scope.$applyAsync(),o.update(),o.eventApiDispatch("onClose",[t]))},this.api.clear=function(t){o.setNgModel(null),o.eventApiDispatch("onClear",[t])},this.api.reset=function(t){o.internalNgModel!==o.initialNgModel&&(o.setNgModel(o.initialNgModel),o.eventApiDispatch("onReset",[t]))},this.api.getElement=function(){return o.$element},this.api.getScope=function(){return o.$scope}}},{key:"setNgModel",value:function(o){this.internalNgModel=o,this.ngModelOptions.getterSetter?this.ngModel(o):this.ngModel=o}},{key:"update",value:function(){if(!this.areAllValuesSet())return!1;var t=o(this.getColorValue());this.swatchColor=t.toHslString(),this.updateGridBackground(t),this.updateHueBackground(t),this.huePosUpdate(),this.updateSaturationBackground(t),this.saturationPosUpdate(),this.updateLightnessBackground(t),this.lightnessPosUpdate(),this.updateOpacityBackground(t),this.opacityPosUpdate();var e=this.options.preserveInputFormat&&o(this.internalNgModel).toHsvString()===t.toHsvString();if(this.updateModel&&!e){var i=t[{rgb:"toRgbString",hex:"toHex",hex8:"toHex8",hexstring:"toHexString",hex8string:"toHex8String",hsv:"toHsvString",hsl:"toHslString",raw:"clone"}[this.options.format.toLowerCase()]]();this.options.format.match(/hex/i)&&(i="upper"===this.options.case?i.toUpperCase():i.toLowerCase()),this.setNgModel(i)}}},{key:"mouseEventToggle",value:function(o,t,e){this.stopEvent(e),this[o+"Mouse"]=!t,this.$scope.$apply()}},{key:"valueChange",value:function(o,t){if(this.stopEvent(t),"color"===o)return this.colorChange(t);var e=this.find(".color-picker-"+o),i=this.getEventPos(t),n=this.getMaxFromType(o);this[o]=this.calculateSliderPos(e,i,n),this[o]>n?this[o]=n:this[o]<0&&(this[o]=0)}},{key:"valueUpdate",value:function(o){if(void 0!==this[o]){if("saturation"===o)this[o+"Pos"]=this[o];else{var t=this.getMaxFromType(o);this[o+"Pos"]=100*(1-this[o]/t)}this[o+"Pos"]<0?this[o+"Pos"]=0:this[o+"Pos"]>100&&(this[o+"Pos"]=100),this.options.round&&(this.getRoundPos(),this.updateRoundPos()),this[o+"PosUpdate"](),this.update()}}},{key:"huePosUpdate",value:function(){var o=angular.element(this.$element[0].querySelector(".color-picker-hue .color-picker-slider"));this.options.horizontal?o.css({left:this.sliderDimensions.width*this.huePos/100+"px",top:0}):o.css({left:0,top:this.sliderDimensions.height*this.huePos/100+"px"})}},{key:"updateHueBackground",value:function(t){var e=this.find(".color-picker-hue .color-picker-overlay"),i=this.options.horizontal?"left":"top",n=this.getColorValue(this.options.dynamicHue),r=this.getColorValue(this.options.dynamicHue),s=this.getColorValue(this.options.dynamicHue),l=this.getColorValue(this.options.dynamicHue),a=this.getColorValue(this.options.dynamicHue),c=this.getColorValue(this.options.dynamicHue),h=this.getColorValue(this.options.dynamicHue);n.h=0,r.h=60,s.h=120,l.h=180,a.h=240,c.h=300,h.h=359,e.css({background:"linear-gradient(to "+i+", "+o(n).toRgbString()+" 0%, "+o(r).toRgbString()+" 17%, "+o(s).toRgbString()+" 33%, "+o(l).toRgbString()+" 50%, "+o(a).toRgbString()+" 67%, "+o(c).toRgbString()+" 83%, "+o(h).toRgbString()+" 100%)"})}},{key:"saturationPosUpdate",value:function(){var o;this.options.round||(o=angular.element(this.$element[0].querySelector(".color-picker-grid .color-picker-picker"))).css({left:this.pickerDimensions.height*this.saturationPos/100+"px"}),o=angular.element(this.$element[0].querySelector(".color-picker-saturation .color-picker-slider")),this.options.horizontal?o.css({left:this.sliderDimensions.width*(100-this.saturationPos)/100+"px",top:0}):o.css({left:0,top:this.sliderDimensions.height*(100-this.saturationPos)/100+"px"})}},{key:"updateSaturationBackground",value:function(t){var e=this.find(".color-picker-saturation .color-picker-overlay"),i=this.options.horizontal?"right":"bottom",n=this.getColorValue(this.options.dynamicSaturation),r=this.getColorValue(this.options.dynamicSaturation);n.s="100%",r.s="0%",e.css({background:"linear-gradient(to "+i+", "+o(n).toRgbString()+" 0%, "+o(r).toRgbString()+" 100%)"})}},{key:"lightnessPosUpdate",value:function(){var o;this.options.round||(o=angular.element(this.$element[0].querySelector(".color-picker-grid .color-picker-picker"))).css({top:this.pickerDimensions.width*this.lightnessPos/100+"px"}),o=angular.element(this.$element[0].querySelector(".color-picker-lightness .color-picker-slider")),this.options.horizontal?o.css({left:this.sliderDimensions.width*this.lightnessPos/100+"px",top:0}):o.css({left:0,top:this.sliderDimensions.height*this.lightnessPos/100+"px"})}},{key:"updateLightnessBackground",value:function(t){var e=this.find(".color-picker-lightness .color-picker-overlay"),i=this.options.horizontal?"right":"bottom",n=this.getColorValue(this.options.dynamicLightness),r=this.getColorValue(this.options.dynamicLightness),s=this.getColorValue(this.options.dynamicLightness);this.options.round?(n.l=100,r.l=50,s.l=0):(n.v=100,r.v=50,s.v=0),e.css({background:"linear-gradient(to "+i+", "+o(n).toRgbString()+" 0%, "+o(r).toRgbString()+" 50%, "+o(s).toRgbString()+" 100%)"})}},{key:"opacityPosUpdate",value:function(){var o=angular.element(this.$element[0].querySelector(".color-picker-opacity .color-picker-slider"));this.options.horizontal?o.css({left:this.sliderDimensions.width*this.opacityPos/100+"px",top:0}):o.css({left:0,top:this.sliderDimensions.height*this.opacityPos/100+"px"})}},{key:"updateOpacityBackground",value:function(t){var e=this.find(".color-picker-opacity .color-picker-overlay"),i=this.options.horizontal?"right":"bottom",n=this.getColorValue(this.options.dynamicAlpha),r=this.getColorValue(this.options.dynamicAlpha);n.a=1,r.a=0,e.css({background:"linear-gradient(to "+i+", "+o(n).toRgbString()+" 0%, "+o(r).toRgbString()+" 100%)"})}},{key:"colorChange",value:function(o){this.stopEvent(o);var t=this.find(".color-picker-grid-inner"),e=this.getEventPos(o),i=this.offset(t);this.options.round?this.colorChangeRound(t,i,e):this.colorChangeSquare(t,i,e)}},{key:"colorChangeRound",value:function(o,t,e){var i=2*(e.pageX-t.left)/o.prop("offsetWidth")-1,n=-2*(e.pageY-t.top)/o.prop("offsetHeight")+1,r=Math.atan2(n,i),s=Math.round(57.29577951308233*r);s<0&&(s+=360),this.hue=s;var l=Math.sqrt(i*i+n*n);l>1?l=1:l<0&&(l=0),this.saturation=100*l,void 0===this.lightness&&(this.lightness=50)}},{key:"colorChangeSquare",value:function(o,t,e){this.saturation=(e.pageX-t.left)/o.prop("offsetWidth")*100,this.lightness=100*(1-(e.pageY-t.top)/o.prop("offsetHeight")),this.saturation>100?this.saturation=100:this.saturation<0&&(this.saturation=0),this.lightness>100?this.lightness=100:this.lightness<0&&(this.lightness=0)}},{key:"updateGridBackground",value:function(t){var e=this.find(".color-picker-grid .color-picker-overlay"),i=this.getColorValue();this.options.round?i.s="0%":(i.s="100%",i.v="100%",i.a=1),e.css({"background-color":o(i).toRgbString(),opacity:t.getAlpha()}),this.find(".color-picker-grid .color-picker-grid-inner").css({opacity:t.getAlpha()})}},{key:"updateSwatchBackground",value:function(){angular.element(this.$element[0].querySelector(".color-picker-swatch")).css({"background-color":this.swatchColor})}},{key:"isColorValid",value:function(o){var t=o.isValid();if(t&&this.options.restrictToFormat&&(t=o.getFormat()===this.getTinyColorFormat()),!t&&this.options.allowEmpty){var e=o.getOriginalInput();void 0!==e&&null!==e&&""!==e||(t=!0)}return t}},{key:"getTinyColorFormat",value:function(){return"hexString"===this.options.format?"hex":"hex8String"===this.options.format?"hex8":this.options.format}},{key:"areAllValuesSet",value:function(){return void 0!==this.hue&&void 0!==this.saturation&&void 0!==this.lightness}},{key:"getColorValue",value:function(){var o=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],t=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],e={h:this.hue,s:o?this.saturation+"%":"100%",v:o?this.lightness+"%":"100%"};return this.options.round&&(e={h:this.hue,s:o?this.saturation+"%":"100%",l:o?this.lightness+"%":"50%"}),t&&(e.a=o?this.opacity/100:1),e}},{key:"setColorValue",value:function(o){var t=!this.anyMouseEvents(),e=this.options.round?o.toHsl():o.toHsv();(t||this.hueMouse)&&(this.hue=e.h),(t||this.saturationMouse)&&(this.saturation=100*e.s),(t||this.lightnessMouse)&&(this.lightness=100*(this.options.round?e.l:e.v)),this.options.alpha&&(t||this.opacityMouse)&&(this.opacity=100*e.a)}},{key:"checkDirty",value:function(o){this.hasOwnProperty("initialNgModel")&&(o===this.initialNgModel?"function"==typeof this.$scope.control[0].$setPristine&&this.$scope.control[0].$setPristine():"function"==typeof this.$scope.control[0].$setDirty&&this.$scope.control[0].$setDirty())}},{key:"stopEvent",value:function(o){o.stopPropagation(),o.preventDefault()}},{key:"getRoundPos",value:function(){var o=.01745329251994*this.hue,t=Math.cos(o)*this.saturation,e=-Math.sin(o)*this.saturation;this.xPos=.5*(t+100),this.yPos=.5*(e+100);if(Math.pow(50-this.xPos,2)+Math.pow(50-this.yPos,2)>Math.pow(50,2)){var i=Math.atan2(this.yPos-50,this.xPos-50);this.xPos=50*Math.cos(i)+50,this.yPos=50*Math.sin(i)+50}}},{key:"updateRoundPos",value:function(){angular.element(this.$element[0].querySelector(".color-picker-grid .color-picker-picker")).css({left:this.pickerDimensions.width*this.xPos/100+"px",top:this.pickerDimensions.height*this.yPos/100+"px"})}},{key:"getEventPos",value:function(o){if(0===o.type.search("touch")){if(o.originalEvent&&o.originalEvent.changedTouches)return o.originalEvent.changedTouches[0];if(o.changedTouches)return o.changedTouches[0]}return o}},{key:"calculateSliderPos",value:function(o,t,e){return this.options.horizontal?Math.round((1-(t.pageX-this.offset(o).left)/o.prop("offsetWidth"))*e):Math.round((1-(t.pageY-this.offset(o).top)/o.prop("offsetHeight"))*e)}},{key:"eventApiDispatch",value:function(o,t){this.eventApi&&"function"==typeof this.eventApi[o]&&(t||(t=[]),t.unshift(this.internalNgModel),t.unshift(this.api),this.eventApi[o].apply(this,t))}},{key:"find",value:function(o){var t,e=this.wrapper?this.wrapper[0]:this.$element[0],i=[];if(!o)return i;if("string"==typeof o){if(1!==(t=e.nodeType)&&9!==t)return[];i=e.querySelectorAll(o)}else e.contains(o)&&i.push(o);return angular.element(i)}},{key:"offset",value:function(o){var t,e,i,n,r=o[0];if(r)return r.getClientRects().length?(i=r.getBoundingClientRect()).width||i.height?(n=r.ownerDocument,e=this.getWindowElements(n),t=n.documentElement,this.chrome&&this.android_version<6&&screen.width<=768?{top:i.top-t.clientTop,left:i.left-t.clientLeft}:{top:i.top+e.pageYOffset-t.clientTop,left:i.left+e.pageXOffset-t.clientLeft}):i:{top:0,left:0}}},{key:"getWindowElements",value:function(o){return null!==o&&o===o.window?o:9===o.nodeType&&o.defaultView}},{key:"anyMouseEvents",value:function(){return this.colorMouse||this.hueMouse||this.saturationMouse||this.lightnessMouse||this.opacityMouse}},{key:"getMaxFromType",value:function(o){return"hue"===o?360:100}}]),t}();r.$inject=["$scope","$element","$document","$timeout","ColorPickerOptions"],t.$inject=["$templateCache"];return angular.module("color.picker",[]).service("ColorPickerOptions",function o(){return i(this,o),{id:void 0,name:void 0,required:!1,disabled:!1,placeholder:"",inputClass:"",restrictToFormat:!1,preserveInputFormat:!1,allowEmpty:!1,format:"hsl",case:"upper",hue:!0,saturation:!1,lightness:!1,alpha:!0,dynamicHue:!0,dynamicSaturation:!0,dynamicLightness:!0,dynamicAlpha:!0,round:!1,pos:"bottom left",inline:!1,horizontal:!1,swatch:!0,swatchOnly:!1,swatchPos:"left",swatchBootstrap:!0,show:{swatch:!0,focus:!0},hide:{blur:!0,escape:!0,click:!0},close:{show:!1,label:"Close",class:""},clear:{show:!1,label:"Clear",class:""},reset:{show:!1,label:"Reset",class:""}}}).directive("colorPicker",function(){return{restrict:"E",require:["^ngModel"],scope:{ngModel:"=",options:"=?",api:"=?",eventApi:"=?"},bindToController:!0,templateUrl:"template/color-picker/directive.html",controller:r,controllerAs:"AngularColorPickerController",link:function(o,t,e,i){o.control=i,o.init()}}}).run(t)});
